/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.model.EnrollContainer;
import pt.caf_pbs.schooldiskapi.model.InstructorContainer;
import pt.caf_pbs.schooldiskapi.model.Subject;

@JsonIgnoreProperties(value={"all"})
public class SubjectContainer
implements Serializable {
    private List<Subject> subjects = new ArrayList();
    private EnrollContainer enrolls;
    private InstructorContainer instructors;

    public List<Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<Subject> subjects) {
        this.subjects = subjects;
    }

    public EnrollContainer getEnrolls() {
        return this.enrolls;
    }

    public void setEnrolls(EnrollContainer enrolls) {
        this.enrolls = enrolls;
    }

    public InstructorContainer getInstructors() {
        return this.instructors;
    }

    public void setInstructors(InstructorContainer instructors) {
        this.instructors = instructors;
    }

    private Subject search(String initials) {
        for (Subject subject : this.subjects) {
            if (!subject.isEqualTo(initials)) continue;
            return subject;
        }
        return null;
    }

    public List<Subject> getAll() {
        ArrayList<Subject> newlist = new ArrayList<Subject>();
        newlist.addAll(this.subjects);
        return newlist;
    }

    public Subject get(String initials) {
        Subject subject = this.search(initials);
        return subject;
    }

    public void add(Subject obj) {
        Subject subject = this.search(obj.getInitials());
        if (subject != null) {
            String msg = "Subject: " + obj.getInitials() + " already exists";
            throw new DuplicatedDataException(msg);
        }
        this.subjects.add(obj);
    }

    public void remove(String initials) {
        Subject subject = this.search(initials);
        if (subject != null) {
            this.subjects.remove(subject);
        }
    }

    public void update(String initials, String designation) {
        Subject subject = this.search(initials);
        if (subject != null) {
            subject.setDesignation(designation);
        }
    }
}

